﻿var createSurvey = {
    context: $(".v-createSurvey"),
    initialize: function () {
        a4.parent().mySurveys.hideBusyBox();

        $(".h-templates-autocomplete", createSurvey.context).a4autocomplete({
            ajaxAction: a4.getAction("GetTemplateCategoriesForAutoComplete", "Templates", "Library"),
            categoryProperty: "Folder",
            sortData: false,
            select: function (event, data) {
                $("#TemplateId").val(data.item.Value);
                $("#Source").removeAttr("checked").prop("checked", false);
                $("#Source[value=Template]").attr("checked", "checked").prop("checked", true);
            }
        });

        $(".h-copyfrom-autocomplete", createSurvey.context).a4autocomplete({
            ajaxAction: a4.getAction("GetSurveysForAutoComplete", "Home", "Survey"),
            categoryProperty: "Folder",
            sortData: true,
            select: function (event, data) {
                $("#CopyFromId").val(data.item.Value);
                $("#Source").removeAttr("checked").prop("checked", false);
                $("#Source[value=Copy]").attr("checked", "checked").prop("checked", true);
            }
        });

        $(".h-userGroupsMultiSelect", createSurvey.context).a4autocomplete({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            multipleSelection: true,
            hideSelectedItems: true,
            altValueField: $("#UserGroupsJson", createSurvey.context)
        });

        createSurvey.context.on("change", ".h-source", function () {
            var source = $(this).val();
            $(".v-hideOnCopySection").toggle(source == "Empty" || source == "Template");
        });

        createSurvey.context.on("change", "#IsOffline", function () {
            var isMobileOffline = $(this).is(":checked");

            $(".v-offlineUserGroupsSection", createSurvey.context).toggle(isMobileOffline);
            $(".v-newEngineSection input", createSurvey.context).prop("disabled", isMobileOffline);
        });

        createSurvey.context.on("change", "#UseS2", function () {
            var useS2 = $(this).is(":checked");
            $(".v-offlineSection input", createSurvey.context).prop("disabled", useS2);
        });

        createSurvey.context.on("click", "#submit1", function () {
            var categoryId = $("#TemplateId").val();
            var surveyName = $(".input-name").val();
            var folderId = $("#hdnFolderId").val();
            var useS2 = $('input[name="UseS2"]').is(":checked");
            var selectedSource = $('input[name="Source"]:checked').val();
            if (categoryId != undefined && categoryId != null && categoryId != "" && surveyName != null && surveyName != "" && selectedSource == 'Template') {
               a4.parent().window.location = a4.getAction("Index", "Templates", "Library", {
                    id: categoryId,
                    name: surveyName,
                   folder: folderId,
                   s2: useS2 != undefined ? useS2 : false
                });
                return false;
            }
            else {
                a4.parent().mySurveys.showBusyBox();
            }
        });
    }
};

$(document).ready(function () {
    if (createSurvey.context.length > 0) {
        createSurvey.initialize();
    }
});